/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.parsing;

import com.aptana.parsing.lexer.ITypePredicate;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JSTokenType implements ITypePredicate
{
    UNDEFINED("UNDEFINED", -1),
    EOF("EOF", 0),
    LPAREN("(", 1),
    IDENTIFIER("IDENTIFIER", 4),
    LCURLY("{", 5),
    LBRACKET("[", 12),
    PLUS_PLUS("++", 18),
    MINUS_MINUS("--", 19),
    STRING("STRING", 16),
    NUMBER("NUMBER", 17),
    MINUS("-", 20),
    PLUS("+", 21),
    FUNCTION("function", 6),
    THIS("this", 10),
    NEW("new", 8),
    NULL("null", 9),
    TRUE("true", 11),
    FALSE("false", 7),
    REGEX("REGEX", 22),
    DELETE("delete", 13),
    EXCLAMATION("!", 23),
    TILDE("~", 24),
    TYPEOF("typeof", 14),
    VOID("void", 15),
    SEMICOLON(";", 25),
    COMMA("comma", 38),
    VAR("var", 26),
    WHILE("while", 27),
    FOR("for", 28),
    DO("do", 29),
    SWITCH("switch", 30),
    IF("if", 31),
    CONTINUE("continue", 33),
    BREAK("break", 34),
    WITH("with", 32),
    RETURN("return", 35),
    THROW("throw", 36),
    TRY("try", 37),
    RPAREN(")", 39),
    ELSE("else", 40),
    RCURLY("}", 44),
    COLON(":", 45),
    RBRACKET("]", 49),
    IN("in", 41),
    EQUAL("=", 66),
    CASE("case", 42),
    DOT(".", 67),
    LESS_LESS("<<", 68),
    GREATER_GREATER(">>", 69),
    GREATER_GREATER_GREATER(">>>", 70),
    LESS("<", 71),
    GREATER(">", 72),
    LESS_EQUAL("<=", 73),
    GREATER_EQUAL(">=", 74),
    INSTANCEOF("instanceof", 43),
    EQUAL_EQUAL("==", 75),
    EXCLAMATION_EQUAL("!=", 76),
    EQUAL_EQUAL_EQUAL("===", 77),
    EXCLAMATION_EQUAL_EQUAL("!==", 78),
    AMPERSAND("&", 79),
    CARET("^", 80),
    PIPE("|", 81),
    AMPERSAND_AMPERSAND("&&", 82),
    STAR_EQUAL("*=", 83),
    FORWARD_SLASH_EQUAL("/=", 84),
    PERCENT_EQUAL("%=", 85),
    PLUS_EQUAL("+=", 86),
    MINUS_EQUAL("-=", 87),
    LESS_LESS_EQUAL("<<=", 88),
    GREATER_GREATER_EQUAL(">>=", 89),
    GREATER_GREATER_GREATER_EQUAL(">>>=", 90),
    AMPERSAND_EQUAL("&=", 91),
    CARET_EQUAL("^=", 92),
    PIPE_EQUAL("|=", 93),
    STAR("*", 94),
    FORWARD_SLASH("/", 95),
    PERCENT("%", 96),
    QUESTION("?", 97),
    PIPE_PIPE("||", 98),
    DEFAULT("default", 46),
    FINALLY("finally", 47),
    CATCH("catch", 48),
    DEBUGGER("debugger", 50),
    CLASS("class", 51),
    ENUM("enum", 52),
    EXPORT("export", 53),
    EXTENDS("extends", 54),
    IMPORT("import", 55),
    SUPER("super", 56),
    IMPLEMENTS("implements", 57),
    INTERFACE("interface", 58),
    LET("let", 59),
    PACKAGE("package", 60),
    PRIVATE("private", 61),
    PROTECTED("protected", 62),
    PUBLIC("public", 63),
    STATIC("static", 64),
    YIELD("yield", 65),
    SET("set", 3),
    GET("get", 2),
    SINGLELINE_COMMENT("SINGLELINE_COMMENT", 1024),
    MULTILINE_COMMENT("MULTILINE_COMMENT", 1025),
    SDOC("SDOC", 1026),
    VSDOC("VSDOC", 1027),
    STRING_SINGLE("STRING_SINGLE", 1028),
    STRING_DOUBLE("STRING_DOUBLE", 1029);

    private static Map<String, JSTokenType> NAME_MAP;
    private static Map<Short, JSTokenType> ID_MAP;
    private String _name;
    private short _index;

    static {
        NAME_MAP = new HashMap<String, JSTokenType>();
        ID_MAP = new HashMap<Short, JSTokenType>();
        for (JSTokenType type : EnumSet.allOf(JSTokenType.class)) {
            NAME_MAP.put(type.getName(), type);
            ID_MAP.put(type.getIndex(), type);
        }
    }

    private JSTokenType(String name, short beaverId) {
        this._name = name;
        this._index = beaverId;
    }

    private JSTokenType(String name, int index) {
        this(name, (short)index);
    }

    public static JSTokenType get(String name) {
        JSTokenType result = UNDEFINED;
        if (NAME_MAP.containsKey(name)) {
            result = NAME_MAP.get(name);
        }
        return result;
    }

    public static JSTokenType get(short id) {
        JSTokenType result = UNDEFINED;
        if (ID_MAP.containsKey(id)) {
            result = ID_MAP.get(id);
        }
        return result;
    }

    public short getIndex() {
        return this._index;
    }

    public String getName() {
        return this._name;
    }

    public boolean isDefined() {
        return this != UNDEFINED;
    }

    public String toString() {
        return this.getName();
    }
}

